<?php

use yii\helpers\Html;
use kartik\detail\DetailView;
use kartik\grid\GridView;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\helpers\Json;

use backend\models\base\Grupo;
use backend\models\base\Genero;
use backend\models\base\Departamento;
use backend\models\base\Municipio;
use backend\models\base\Tipodocumento;
use backend\models\base\Religion;
use backend\models\base\Etnia;
use backend\models\base\Rh;
use backend\models\base\Eps;
use backend\models\base\Barrio;
use backend\models\base\Tipotercero;
use backend\models\base\Terceroestado;
use backend\models\base\Parentesco;


$this->title = $model->primer_nombre.' '.$model->segundo_nombre.' '.$model->primer_apellido.' '.$model->segundo_apellido;
$this->params['breadcrumbs'][] = ['label' => 'Terceros', 'url' => ['index']];
//$this->params['breadcrumbs'][] = $this->title;

$this->params['actions'][] = ['label' => 'Actualizar', 'url' => 'update', 'id' => $model->id, 'icon' => '<i class="far fa-pencil"></i>', 'class' => 'primary'];
$this->params['actions'][] = ['label' => 'Nuevo', 'url' => 'create', 'icon' => '<i class="far fa-plus"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Listar', 'url' => 'index', 'icon' => '<i class="far fa-bars"></i>', 'class' => 'purple'];
$this->params['actions'][] = ['label' => 'Hoja de Vida', 'url' => 'hojadevida', 'id' => $model->id, 'icon' => '<i class="far fa-file-pdf"></i>', 'class' => 'danger'];
$this->params['actions'][] = ['label' => 'Eliminar', 'url' => 'delete', 'id' => $model->id, 'icon' => '<i class="far fa-trash-alt"></i>', 'class' => 'danger'];



?>

<div class="container">

  <div class="tercero-view">

    <div class="row">

        <div class="col-sm-12">
            <?= Html::img($model->foto ? '@web/uploads/thumbnail/sm-'.$model->foto : '@web/images/user.jpg', ['class'=>'foto img-circle img-responsive img-50']); ?>
            <h2 class="tercero"><?= Html::encode($model->nombre) ?></h2>
            <br>
        </div>
    </div>

    <div class="row">
<?php 


    $color = "default";
    $estado = "";

    if ($model->tipo_tercero==1) $color="success";
    if ($model->tipo_tercero==2) $color="info";
    if ($model->tipo_tercero==3) $color="warning";
    if ($model->tipo_tercero==4) $color="danger"; 

    if ($model->tipo_tercero==1)
    {    
        $estado = "<span class='label label-default'>";
        $estado .= ($model->tipo_tercero==1) ? $model->estados->estado : 'No Aplica';
        $estado .= "</span>";
    }
        
    if (!isset($model->grupo))
    {
        $grupo =($model->tipo_tercero==1) ? Html::a('<span class="label label-danger">Sin Grupo</span>',['/academico/create', 'id' => $model->id]) : ''; 
    }
    else
    {
        $data = Grupo::findOne($model->Grupo);
        $grupo ='<span class="label label-success">'.($data ? $data->grupo : 'Sin Grupo').'</span>';
    } 

    $gridColumn = [
        [
            'group'=>true,
            'label'=>'Información Básica',
            'rowOptions'=>['class'=>'info']
        ],
        [
            'columns' => [
                [
                    'attribute' => 'identificacion',
                    'valueColOptions'=>['style'=>'width:30%'],
                ],
                [
                    'attribute'=>'tipo',
                    'value'=>$model->tipos->tipo,
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Tipodocumento::find()->asArray()->all(), 'id', 'tipo'),
                    ],
                ],
                
            ],
        ], 

        [    
            'columns' => [
                [
                    'attribute'=>'genero',
                    'value'=>$model->generos->genero,
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2,
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Genero::find()->asArray()->all(), 'id', 'genero'),
                    ],
                ], 
                [
                    'attribute' => 'tipo_tercero',
                    'label' => 'Tipo Tercero',
                    'format' => 'RAW',
                    'value' => "<span class='label label-{$color}'>".$model->tipoterceros->tipo."</span>&nbsp;&nbsp;".$estado."&nbsp;&nbsp;".$grupo,
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2,
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Tipotercero::find()->asArray()->all(), 'id', 'tipo'),
                    ],
                ],           
                
            ],
        ],
        [    
            'columns' => [ 
                
                [
                    'attribute'=>'fecha_nacimiento', 
                    'format'=>'date',
                    'type'=>DetailView::INPUT_DATE,
                    'widgetOptions' => [
                        'pluginOptions'=>['autoclose' => true,
                                          'format' => 'yyyy-mm-dd',
                                          'todayHighlight' => true]
                    ],
                    'valueColOptions'=>['style'=>'width:30%'],
                ],
                [
                    'attribute'=>'genero',
                    'value'=>$model->generos->genero,
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2,
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Genero::find()->asArray()->all(), 'id', 'genero')],
                    'valueColOptions'=>['style'=>'width:30%']
                ],
            ],
        ], 

        [    
            'columns' => [
                [
                    'attribute'=>'departamento_nacimiento',
                    'value'=> $model->departamento_nacimiento ? $model->departamentos->nombre : '',
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Departamento::find()->asArray()->all(), 'id', 'nombre'),
                    ],
                ],   
                [
                    'attribute'=>'municipio_nacimiento',
                    'value'=> $model->municipio_nacimiento ? $model->municipios->nombre : '',
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Municipio::find()->asArray()->all(), 'id', 'nombre'),
                    ],
                ],
            ],
        ],        
        [
            'group'=>true,
            'label'=>'Información Adicional',
            'rowOptions'=>['class'=>'warning']
        ],
        [    
            'columns' => [
                [
                    'attribute' => 'rh',
                    'value'=> $model->rh ? $model->rhs->rh : '',
                    'type'=>DetailView::INPUT_SELECT2,
                    'valueColOptions'=>['style'=>'width:30%'], 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Rh::find()->asArray()->all(), 'id', 'rh'),
                    ],
                ],    
                [
                    'attribute' => 'religion',
                    'label' => 'Religión',
                    'value' => $model->religion ? $model->religiones->religion : '',
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Religion::find()->asArray()->all(), 'id', 'religion'),
                    ],
                ],    
            ],
        ],
        [    
            'columns' => [
                [
                    'attribute' => 'etnia',
                    'value' => $model->etnia ? $model->etnias->etnia : '',
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Etnia::find()->asArray()->all(), 'id', 'etnia'),
                    ],
                ],
                [
                    'attribute' => 'eps',
                    'value' => $model->eps ? $model->epss->eps : '',
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Eps::find()->asArray()->all(), 'id', 'eps'),
                    ],
                ],
                
            ],
    ],    
    [
        'group'=>true,
        'label'=>'Información de Contácto',
        'rowOptions'=>['class'=>'success']
    ],
    [    
            'columns' => [
                [
                    'attribute' => 'direccion',
                    'valueColOptions'=>['style'=>'width:30%'],
                ],
                [
                    'attribute' => 'barrio',
                    'value' => $model->barrio ? $model->barrios->nombre : '',
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Barrio::find()->asArray()->all(), 'id', 'barrio'),
                    ],
                ],
            ],
    ], 
    [    
            'columns' => [
                [
                    'attribute' => 'fijo',
                    'valueColOptions'=>['style'=>'width:30%'],
                ],
                [
                    'attribute' => 'movil',
                    'valueColOptions'=>['style'=>'width:30%'],
                ],
                   
            ],
    ],
        [    
            'columns' => [
                'email:email', /*
                [
                    'attribute' => 'foto',
                    'valueColOptions'=>['style'=>'width:33%'],
                ],
                [
                    'attribute' => 'estado',
                    'valueColOptions'=>['style'=>'width:33%'],
                ],*/
            ],
    ],                  
 ];

    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn,
        'mode' => 'view',
        'enableEditMode' => false,
        'bordered' => true,
        'striped' => false,
        /*'panel' => [
            'heading' => '',
            'type' => DetailView::TYPE_SUCCESS,
        ],*/
        'condensed' => false,
        'responsive' => true,
        'hover' => true,
        'hAlign'=> 'center',
        'vAlign'=> 'center',
        'fadeDelay'=> '1000',
        'deleteOptions'=>[ // your ajax delete parameters
            //'params' => ['id' => 1000, 'kvdelete'=>true],
                'params' => ['custom_param'=>true],
                'url'=>['delete', 'id' => $model->id],
        ],
        'container' => ['id'=>'kv-demo'],
        'formOptions' => ['action' => Url::current(['#' => 'delete'])] // your action to delete
    ]);
?>
    </div>

    <div class="row">
<?php
if($providerAcademico->totalCount){
    $gridColumnAcademico = [
        ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute' => 'estudiantes.primer_nombre',
                'label' => 'Estudiante'
        ],
            [
                'attribute' => 'grupos.grupo',
                'label' => 'Grupo'
        ],
            'fecha_matricula',
            'fecha_retiro',
            'aprobo',
            'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerAcademico,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-academico']],
        'panel' => [
        'type' => GridView::TYPE_PRIMARY,
        'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode('Academico'.' '. $this->title),
        ],
        'columns' => $gridColumnAcademico
    ]);
}
?>
    </div>
 

 <div class="row">
<?php
if($providerAcudiente->totalCount){
    $gridColumnAcudiente = [
        ['class' => 'yii\grid\SerialColumn'],
            /*[
                'attribute' => 'estudiantes.nombre',
                'label' => 'Estudiante'
        ],*/
        [
            'attribute' => 'nombre',
            'label' => 'Nombres y Apellidos',
        ], 
        [
            'attribute' => 'identificacion',
            'label' => 'Cédula',
        ],    
           
            /*'primer_nombre',
            'segundo_nombre',
            'primer_apellido',
            'segundo_apellido',*/
            [
                'attribute' => 'generos.genero',
                'label' => 'Género'
        ],
            [
                'attribute' => 'parentescos.parentesco',
                'label' => 'Parentesco'
        ],
            [
                'attribute' => 'rhs.rh',
                'label' => 'RH'
        ],
            //'direccion',
            'fijo',
            'movil',
            //'email:email',
            //'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerAcudiente,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-acudiente']],
        'panel' => [
        'type' => GridView::TYPE_PRIMARY,
        'heading' => '<span class="fa fa-users"></span> ' . Html::encode('Acudientes de'.' '. $this->title),
        ],
        'export' => false,
        'columns' => $gridColumnAcudiente
    ]);
}
?>
    </div> 


    <div class="row">
<?php
if($providerAsistencia->totalCount){
    $gridColumnAsistencia = [
        ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute' => 'asignaturas.asignatura',
                'label' => 'Asignatura'
        ],
            [
                'attribute' => 'grupos.grupo',
                'label' => 'Grupo'
        ],
            [
                'attribute' => 'periodos.periodo',
                'label' => 'Periodo'
        ],
            [
                'attribute' => 'directores.primer_nombre',
                'label' => 'Docente'
        ],
            [
                'attribute' => 'terceros.primer_nombre',
                'label' => 'Estudiante'
        ],
            'asistio',
            'fallas',
            [
                'attribute' => 'tipoInasistencias.tipo_inasistencia',
                'label' => 'Tipo Inasistencia'
        ],
            'fecha',
            'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerAsistencia,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-asistencia']],
        'panel' => [
        'type' => GridView::TYPE_PRIMARY,
        'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode('Asistencia'.' '. $this->title),
        ],
        'columns' => $gridColumnAsistencia
    ]);
}
?>
    </div>
    

    <div class="row">
<?php
if($providerGrupo->totalCount){
    $gridColumnGrupo = [
        ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute' => 'grados.grado',
                'label' => 'Grado'
        ],
            'grupo',
            [
                'attribute' => 'directores.primer_nombre',
                'label' => 'Director'
        ],
            [
                'attribute' => 'jornadas.jornada',
                'label' => 'Jornada'
        ],
            [
                'attribute' => 'sedes.sede',
                'label' => 'Sede'
        ],
            'por_nota',
            [
                'attribute' => 'metodologias.metodologia',
                'label' => 'Metodologia'
        ],
            [
                'attribute' => 'modalidades.modalidad',
                'label' => 'Modalidad'
        ],
            [
                'attribute' => 'especialidades.especialidad',
                'label' => 'Especialidad'
        ],
            'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerGrupo,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-grupo']],
        'panel' => [
        'type' => GridView::TYPE_PRIMARY,
        'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode('Grupo'.' '. $this->title),
        ],
        'columns' => $gridColumnGrupo
    ]);
}
?>
    </div>

 <div class="row">
<?php
if($providerPlanAula->totalCount){
    $gridColumnPlanAula = [
        ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute' => 'docentes.nombre',
                'label' => 'Docente'
        ],
            
            'semana_inicio',
            'semana_fin',
            [
                'attribute' => 'grados.grado',
                'label' => 'Grado'
        ],
            [
                'attribute' => 'asignaturas.asignatura',
                'label' => 'Asignatura'
        ],
            [
                'attribute' => 'grupos.grupo',
                'label' => 'Grupo'
        ],
            'estandar:ntext',
            [
                'attribute' => 'periodos.periodo',
                'label' => 'Periodo'
        ],
            [
                'attribute' => 'competencias.competencia',
                'label' => 'Competencia'
        ],
            'unidad',
            'nombre_unidad',
            'horas',
            'derechos:ntext',
            'inicio:ntext',
            'desarrollo:ntext',
            'cierre:ntext',
            'formativa:ntext',
            'articulacion:ntext',
            'recursos:ntext',
            'reflexion:ntext',
            'observaciones:ntext',
            'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerPlanAula,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-plan-aula']],
        'panel' => [
        'type' => GridView::TYPE_PRIMARY,
        'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode('Plan Aula'.' '. $this->title),
        ],
        'columns' => $gridColumnPlanAula
    ]);
}
?>
    </div>     
  </div>
</div>